<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pw_change_api extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('pw_change_api_model');

		$_POST = json_decode(file_get_contents('php://input'), true);
	}

	public function index() {

	}

	public function check_login() {
		$login_data = $this->pw_change_api_model->login($_POST["username"], $_POST["password"]);
		if ($login_data !== false) {
			$this->load->view("json", array("data" => array(
				"text" => "prijava uspešna",
				"login_data" => $login_data
			)));
		} else {
			$this->load->view("json", 
				array(
					"data" => array(
						"type" => 403,
						"text" => $this->pw_change_api_model->error
					),
					"header" => "HTTP/1.0 403 Forbidden"
				)
			);
		}
	}

	public function change_password() {
		if ($this->pw_change_api_model->login($_POST["username"], $_POST["old_pw"])) {
			if ($this->check_password($_POST["username"], $_POST["old_pw"], $_POST["new_pw"], $_POST["new_pw2"])) {
				if ($this->pw_change_api_model->change_password($_POST["username"], $_POST["new_pw"])) {
					$this->load->view("json", array("data" => array(
						"text" => "geslo uspešno spremenjeno"
					)));					
				} else {
					$this->load->view("json", 
						array(
							"data" => array(
								"type" => 500,
								"text" => $this->pw_change_api_model->error
							),
							"header" => "HTTP/1.0 500 Error"
						)
					);
				}

			} else {
				$this->load->view("json", 
					array(
						"data" => array(
							"type" => 403,
							"text" => "Password complexity check failed: ".$this->change_fail_reason
						),
						"header" => "HTTP/1.0 403 Forbidden"
					)
				);
			}
		} else {
			$this->load->view("json", 
				array(
					"data" => array(
						"type" => 403,
						"text" => $this->pw_change_api_model->error
					),
					"header" => "HTTP/1.0 403 Forbidden"
				)
			);
		}
	}

	var $username;
	var $old_pw;
	var $new_pw;
	var $new_pw2;
	var $change_fail_reason;

	private function check_password($username, $old_pw, $new_pw, $new_pw2) {

		$this->username = $username;
		$this->old_pw = $old_pw;
		$this->new_pw = $new_pw;
		$this->new_pw2 = $new_pw2;

		$checks = array(
			"username",
			"length",
			"categories",
			"categories_big",
			"categories_small",
			"categories_numbers",
			"categories_notalphanumeric",
			"pw_match",
			"pw_diff"
		);

		$must_valid = array(
			"username",
			"length",
			"categories",
			"pw_match",
			"pw_diff"
		);

		$valid = true;

		foreach($checks as $key => $value) {
			if (!$this->$value() && in_array($value, $must_valid)) {
				$valid = false;
				$this->change_fail_reason = $value;
			}
		};

		$this->old_pw = "";
		$this->new_pw = "";
		$this->new_pw2 = "";

		return $valid;
	}

	private function username() {
		function get_longest_common_subsequence($string_1, $string_2) //http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Longest_common_substring#PHP
		{
			$string_1_length = strlen($string_1);
			$string_2_length = strlen($string_2);
			$return          = "";
		 
			if ($string_1_length === 0 || $string_2_length === 0)
			{
				// No similarities
				return $return;
			}
		 
			$longest_common_subsequence = array();
		 
			// Initialize the CSL array to assume there are no similarities
			for ($i = 0; $i < $string_1_length; $i++)
			{
				$longest_common_subsequence[$i] = array();
				for ($j = 0; $j < $string_2_length; $j++)
				{
					$longest_common_subsequence[$i][$j] = 0;
				}
			}
		 
			$largest_size = 0;
		 
			for ($i = 0; $i < $string_1_length; $i++)
			{
				for ($j = 0; $j < $string_2_length; $j++)
				{
					// Check every combination of characters
					if ($string_1[$i] === $string_2[$j])
					{
						// These are the same in both strings
						if ($i === 0 || $j === 0)
						{
							// It's the first character, so it's clearly only 1 character long
							$longest_common_subsequence[$i][$j] = 1;
						}
						else
						{
							// It's one character longer than the string from the previous character
							$longest_common_subsequence[$i][$j] = $longest_common_subsequence[$i - 1][$j - 1] + 1;
						}
		 
						if ($longest_common_subsequence[$i][$j] > $largest_size)
						{
							// Remember this as the largest
							$largest_size = $longest_common_subsequence[$i][$j];
							// Wipe any previous results
							$return       = "";
							// And then fall through to remember this new value
						}
		 
						if ($longest_common_subsequence[$i][$j] === $largest_size)
						{
							// Remember the largest string(s)
							$return = substr($string_1, $i - $largest_size + 1, $largest_size);
						}
					}
					// Else, $CSL should be set to 0, which it was already initialized to
				}
			}
		 
			// Return the list of matches
			return $return;
		}

		return strlen(get_longest_common_subsequence($this->new_pw, $this->username)) <= 2;
	}
	private function length() {
		return strlen($this->new_pw) >= 8;
	}
	private function categories_big() {
		return preg_match('/[A-Z]/', $this->new_pw) == 1;
	}
	private function categories_small() {
		return preg_match('/[a-z]/', $this->new_pw) == 1;
	}
	private function categories_numbers() {
		return preg_match('/[0-9]/', $this->new_pw) == 1;
	}
	private function categories_notalphanumeric() {
		return preg_match('/\W/', $this->new_pw) == 1;
	}
	private function categories() {
		$matches = 0;
		if ($this->categories_big()) $matches++;
		if ($this->categories_small()) $matches++;
		if ($this->categories_numbers()) $matches++;
		if ($this->categories_notalphanumeric()) $matches++;
		return $matches >= 3;
	}
	private function pw_match() {
		return $this->new_pw == $this->new_pw2;
	}
	private function pw_diff() {
		return $this->old_pw != $this->new_pw;
	}
}
