<?
$username = "";

if (isset($_GET["username"])) {
	$username = $_GET["username"];
}
?><!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

	<script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.min.js"></script>

	<link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css" />
	<script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js"></script>

	<link href="//netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap.min.css" rel="stylesheet">
	<!--<link href="//netdna.bootstrapcdn.com/bootswatch/3.1.1/lumen/bootstrap.min.css" rel="stylesheet">-->
	<script src="//netdna.bootstrapcdn.com/bootstrap/3.1.1/js/bootstrap.min.js"></script>
	<link href="//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.min.css" rel="stylesheet">

	<title>Spreminjanje gesla</title>
	<meta charset="UTF-8">
	<style type="text/css">
		.bs-callout {
			margin: 10px 0;
			padding: 5px 30px 5px 15px;
			border-left: 5px solid #eee;
		}

		.bs-callout.invalid {
			background-color: #fcf2f2;
			border-color: #dFb5b4;
		}

		.bs-callout.valid {
			background-color: #dff0d8;
			border-color: #d6e9c6;
		}

		.sub {
			margin-left: 15px;
		}

		label span.valid {
			color: #d6e9c6;
			display: none;
		}

		label span.invalid {
			color: #ff3333;
		}

		#pwd_last_set {
			color: gray;
			font-weight: normal;
		}
	</style>
</head>
<body>
	<div class="container">
		<h2>Zamenjava gesla za storitve UP vezane na LDAP</h2>
		<form id="pw_change_form" class="form-horizontal" method="post" action="pw_change.php">
			<div class="row">
				<div class="col-md-6">
					<div class="control-group">
						<label class="control-label" for="username">Uporabniško ime</label>
						<div class="controls">
							<input type="text" class="form-control check_change" id="username" placeholder="vnesite vaše uporabniško ime" value="<?=$username?>">
						</div>
					</div>			
					<div class="control-group">
						<label class="control-label" for="old_pw">
							Trenutno geslo <i id="trenutno_spinner" style="display: none" class="fa fa-spinner fa-spin"></i>
							<span id="login_error" class="valid"></span>
							<span id="pwd_last_set"></span>
						</label>
						<div class="controls">
							<input type="password" class="form-control check_change" id="old_pw" placeholder="vnesite trenutno geslo">
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" for="new_pw">
							Novo geslo
							<span class="pw_diff">Novo geslo mora biti različno od trenutnega</span>
							<!--<span class="username">Geslo ne sme vsebovati imena ali dele uporabniških imen, ki presegajo dva zaporedna znaka iz računa uporabnika (uporabniško ime).</span>
							<span class="length">Geslo mora biti dolgo najmanj osem znakov</span>-->
						</label>
						<div class="controls">
							<input type="password" class="form-control check_change" id="new_pw" placeholder="vnesite novo geslo">
						</div>
					</div>
					<div class="control-group">
						<label class="control-label" for="new_pw2">
							Ponovite novo geslo
							<span class="pw_match">Gesli se ne ujemata</span>
						</label>
						<div class="controls">
							<input type="password" class="form-control check_change" id="new_pw2" placeholder="ponovno vnesite geslo">
						</div>
					</div>
					<div class="control-group">
						<br>
						<div id="change_status" class="alert" style="display: none;"></div>
						<div class="controls">
							<button type="submit" id="submit" class="btn btn-default">
								<span id="change_spinner" style="display: none"><i class="fa fa-spinner fa-spin"></i> Spreminjam... - sprememba traja približno 5 sekund</span>
								<span id="n_change_spinner">Spremeni geslo</span>
							</button>
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<!--<div class="bs-callout pw_match">
					Gesli v poljih <b>Novo geslo</b> in <b>Ponovite novo geslo</b> se morata ujemati
					</div>
					<div class="bs-callout pw_diff">
					Novo geslo mora biti različno od trenutnega
					</div>-->
					<div class="bs-callout username">
					Geslo ne sme vsebovati imena ali dele uporabniških imen, ki presegajo dva zaporedna znaka iz računa uporabnika (uporabniško ime).
					</div>
					<div class="bs-callout length">
					Geslo mora biti dolgo najmanj osem znakov
					</div>
					<div class="bs-callout categories">
					Geslo mora vsebovati znake iz vsaj treh od spodnjih štirih kategorij:
					</div>
					<div class="bs-callout sub categories_big">
					velike črke angleške abecede (A-Z)
					</div>
					<div class="bs-callout sub categories_small">
					male črke angleške abecede (a-z)
					</div>
					<div class="bs-callout sub categories_numbers">
					vsaj eno iz števko (0-9)
					</div>
					<div class="bs-callout sub categories_notalphanumeric">
					ne-alfanumerične znake (npr. !$#%@.)
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					
				</div>
			</div>
		</form>
	</div>
	<script type="text/javascript">
		var pw_change_api_url = "pw_change_api/index.php/pw_change_api/";

		$(".check_change").on("keyup", function() {
			setTimeout(function() {
				check_password();
			}, 1);
		});

		$("#old_pw").on("change", function() {
			$("#login_error").addClass("valid");
			$("#login_error").removeClass("invalid");
			$("#pwd_last_set").html("");

			$("#change_status").css("display", "none");

			$("#trenutno_spinner").css("display", "inline-block");

			$.ajax({
				type: "POST",
				url: pw_change_api_url + "check_login",
				// The key needs to match your method's input parameter (case-sensitive).
				data: JSON.stringify({
					username : $("#username")[0].value,
					password : $("#old_pw")[0].value
				}),
				contentType: "application/json; charset=utf-8",
				dataType: "json",
				success: function(data){
					$("#trenutno_spinner").css("display", "none");

					if (data.login_data.pwd_last_set) {
						var date = new Date(data.login_data.pwd_last_set * 1000);
						var now = new Date();
						var diffDays = Math.round(Math.abs((date.getTime() - now.getTime())/(24*60*60*1000)));
						$("#pwd_last_set").html(" - zadnjič spremenjeno: " + date.getDate() + "." + (date.getMonth() + 1) + "." + date.getFullYear() + " (pred " + diffDays + " dnevi)");
					}
				},
				error: function(errMsg, data) {
					$("#trenutno_spinner").css("display", "none");

					$("#login_error").html(JSON.parse(errMsg.responseText).text);
					$("#login_error").removeClass("valid");
					$("#login_error").addClass("invalid");
				}
			});
		});

		$("#pw_change_form").submit(function(event) {
			if (!check_password()) {
				//alert("novo geslo ne ustreza zahtevam!");
				$(".bs-callout.invalid").effect("highlight", {color : "#ff6666"}, "slow");
				$("label span.invalid").effect("highlight", {color : "#ff6666"}, "slow");
				event.preventDefault();	
			} else {
				$("#change_status").css("display", "none");

				$("#change_spinner").css("display", "inline");
				$("#n_change_spinner").css("display", "none");

				$.ajax({
				type: "POST",
				url: pw_change_api_url + "change_password",
				data: JSON.stringify({
					username : $("#username")[0].value,
					old_pw : $("#old_pw")[0].value,
					new_pw : $("#new_pw")[0].value,
					new_pw2 : $("#new_pw2")[0].value
				}),
				contentType: "application/json; charset=utf-8",
				dataType: "json",
				success: function(data){
					$("#change_spinner").css("display", "none");
					$("#n_change_spinner").css("display", "inline");

					$("#old_pw")[0].value = "";
					$("#new_pw")[0].value = "";
					$("#new_pw2")[0].value = "";

					$("#pwd_last_set").html("");

					$("#change_status").addClass("alert-success");
					$("#change_status").removeClass("alert-danger");
					$("#change_status").html(data.text);
					$("#change_status").css("display", "block");

					check_password();
				},
				error: function(errMsg, data) {
					$("#change_spinner").css("display", "none");
					$("#n_change_spinner").css("display", "inline");

					$("#change_status").removeClass("alert-success");
					$("#change_status").addClass("alert-danger");
					$("#change_status").html(errMsg.responseJSON.text);
					$("#change_status").css("display", "block");
				}
			});

				event.preventDefault();
			}

		});
		
		var check_password = function() {
			$("change_status").css("display", "none");
			var new_pw = $("#new_pw")[0].value;

			var check = function(what) {
				if (fns[what] == undefined) {
					console.error("no function for " + what);
					return true;
				}
				var result = fns[what]();
				//console.log(what, new_pw, result);
				if (result) {
					$("." + what).removeClass("invalid");
					$("." + what).addClass("valid");					
				} else {
					$("." + what).removeClass("valid");
					$("." + what).addClass("invalid");					
				}

				return result;
			}

			var fns = {
				username : function() {
					function lcs(lcstest, lcstarget) { //http://cache.mifio.com/javascript002.html
					 matchfound = 0
					 lsclen = lcstest.length
					  for(lcsi=0; lcsi<lcstest.length; lcsi++){
					   lscos=0
					    for(lcsj=0; lcsj<lcsi+1; lcsj++){
					     re = new RegExp("(?:.{" + lscos + "})(.{" + lsclen + "})", "i");
					     temp = re.test(lcstest);
					     re = new RegExp("(" + RegExp.$1 + ")", "i");
					      if(re.test(lcstarget)){
					       matchfound=1;
					       result = RegExp.$1;
					       break;
					       }
					     lscos = lscos + 1;
					     }
					     if(matchfound==1){return result; break;}
					    lsclen = lsclen - 1;
					   }
					  result = "";
					  return result;
					 }

					 return lcs(new_pw, $("#username")[0].value).length <= 2 && $("#username")[0].value != "";
				},
				length : function() {
					return new_pw.length >= 8;
				},
				categories_big : function() {
					return new_pw.match(/[A-Z]/);
				},
				categories_small : function() {
					return new_pw.match(/[a-z]/);
				},
				categories_numbers : function() {
					return new_pw.match(/[0-9]/);
				},
				categories_notalphanumeric : function() {
					return new_pw.match(/\W/);
				},
				categories : function() {
					var matches = 0;
					if (fns.categories_big()) matches++;
					if (fns.categories_small()) matches++;
					if (fns.categories_numbers()) matches++;
					if (fns.categories_notalphanumeric()) matches++;
					return matches >= 3;
				},
				pw_match : function() {
					return $("#new_pw2")[0].value == new_pw || $("#new_pw2")[0].value == "";
				},
				pw_diff : function() {
					return $("#old_pw")[0].value != new_pw || new_pw == "";
				}
			}

			var checks = [
				"username",
				"length",
				"categories",
				"categories_big",
				"categories_small",
				"categories_numbers",
				"categories_notalphanumeric",
				"pw_match",
				"pw_diff"
			];

			var must_valid = [
				"username",
				"length",
				"categories",
				"pw_match",
				"pw_diff"
			];

			var valid = true;

			$.each(checks, function(key, value) {
				if (!check(value) && $.inArray(value, must_valid) != -1 ) {
					valid = false;
				}
			});

			if (valid && $("#new_pw2")[0].value == "") {
				$(".invalid").removeClass("invalid");
				valid = false;
			}

			if (valid) {
				$(".show_valid").css("display", "block");
				$("#submit").removeClass("btn-default");
				$("#submit").addClass("btn-primary");
				$(".invalid").removeClass("invalid");
			} else {
				$(".show_valid").css("display", "none");				
				$("#submit").addClass("btn-default");
				$("#submit").removeClass("btn-primary");
			}
			return valid;
		}

		//check_password();
	</script>
</body>
</html>