<?php
class  Pw_change_api_model extends CI_Model {

	var $ldap_server = "ldap.upr.si";
	var $error = false;
	var $ldap_connection = false;
	var $ldap_admin_dn = "cn=admin,dc=upr,dc=si";
	var $ldap_admin_pw = "ChangeMeNOW2024!";


	function __construct() {
		parent::__construct();
	}

	private function connect_ldap_anonymous() {
		$this->ldap_connection = ldap_connect($this->ldap_server, 389);
		ldap_set_option($this->ldap_connection, LDAP_OPT_PROTOCOL_VERSION, 3);
		if ($this->ldap_connection) {
			$bind = @ldap_bind($this->ldap_connection);
			if ($bind) {
				return true;				
			} else {
				$this->error = "ldap anonymous bind failed";
				return false;
			}
		} else {
			$this->error = "ldap connect failed";
			return false;
		}
	}

	private function connect_ldap_admin() {
		if ($this->connect_ldap_anonymous()) {
			$bind = @ldap_bind($this->ldap_connection, $this->ldap_admin_dn, $this->ldap_admin_pw);
			if ($bind) {
				return true;
			} else {
				$this->error = "ldap admin bind failed";
				return false;
			}
		} else {
			return false;
		}
	}

	function login($username,$password){
		$username=$this->ldap_escape($username);
		//se povezem na streznik

		$connection = ldap_connect($this->ldap_server);
		//to more bit ki cene ne dela
		ldap_set_option($connection, LDAP_OPT_PROTOCOL_VERSION, 3);

		restore_error_handler();
		if ($connection) {
			//se bindam anonimno
			$bind = @ldap_bind($connection);
			//sem noter dam potem uporabnikov dn
			$userdn = "";
			$displayname = "";
			if ($bind) {
				//iscemo dn uporabnika s podanim uid
				$search = ldap_search($connection,"dc=upr,dc=si","(uid=".$username.")", array("dn", "displayname", "givenName", "sn"));
				$result = ldap_get_entries($connection, $search);
				//$result["count"] je stevilo vrnjenih ldap predmetov - pricakujemo natanko enega
				if ($result["count"] != 1){
					$this->error = "Napačno uporabniško ime ali geslo";
					return false;
				}
				//ce imamo samo enega pol njegov dn uporabimo za login
				$userdn = $result[0]["dn"];
				$displayname = $result[0]["displayname"];
				$givenName = $result[0]["givenname"];
				$surname = $result[0]["sn"];
			} else {
				$this->error = "Napaka na strežniku: LDAP anonymous bind failed...";
				return false;
			}
			
			//se bindamo kot podan uporabnik
			$bind = @ldap_bind($connection, $userdn, $password);

			if ($bind) {
				//ce uspe bind potem je vse v redu
				$search = ldap_search($connection,"dc=upr,dc=si","(uid=".$username.")", array("dn", "displayname", "givenName", "sn", "sambaPwdLastSet"));
				$result = ldap_get_entries($connection, $search);
				$pwd_last_set = false;
				if (isset($result[0]["sambapwdlastset"])) {
					$pwd_last_set = $result[0]["sambapwdlastset"][0];
				}
				return array(
					"username" => $username,
					"name" => $givenName[0],
					"surname" => $surname[0],
					"pwd_last_set" => $pwd_last_set
				);
			} else {
				$this->error = "Napačno geslo";
				return false;
			}
		} else {
			$this->error = "Napaka na strežniku: Could not connect to LDAP server.";
			return false;
		}
		$this->error="Napaka na strežniku: Unknown error.";
		return false;
	}

	private function ldap_escape($string) {
		return str_replace(array('*', '\\', '(', ')'), array('\\*', '\\\\', '\\(', '\\)'), $string);
	}

	private function find_dn($username) {
		if ($this->connect_ldap_anonymous()) {
			$search = ldap_search($this->ldap_connection, "dc=upr,dc=si","(uid=".$username.")", array("dn"));
			$result = ldap_get_entries($this->ldap_connection, $search);
			if ($result["count"] != 1){
				$this->error = "Uporabnik ne obstaja";
				return false;
			} else {
				return $result[0]["dn"];
			}
		} else {
			return false;
		}
	}

	//doda samba stuff
	private function fix_user_ldap($dn) {
		if ($this->connect_ldap_admin()) {

			$search = ldap_read($this->ldap_connection, $dn, "(objectClass=*)" ,array("dn", "objectClass"));
			$result = ldap_get_entries($this->ldap_connection, $search);

			$classess = $result[0]["objectclass"];

			if (in_array("sambaSamAccount", $classess)) {
				return;
			}

			$entry["objectclass"][0] = "sambaSamAccount";
			$entry["sambaSID"][0] = "pw_change_" . time();

			if (ldap_mod_add($this->ldap_connection, $dn, $entry)) {
				return true;
			} else {
				$this->error = ldap_errno($this->ldap_connection) . ": ".ldap_err2str(ldap_errno($this->ldap_connection));
				return false;
			}

		} else {
			return false;
		}
	}

	function change_password($username, $password) {
		$username = $this->ldap_escape($username);
		$dn = $this->find_dn($username);

		if ($this->connect_ldap_admin()) {
			$this->fix_user_ldap($dn);
			
			include "createlm.php";
			$sambapassword = new smbHash;

			$entry["sambalmpassword"][0] = $sambapassword->lmhash($password);
			$entry["sambantpassword"][0] = $sambapassword->nthash($password);
			$entry["userPassword"][0] = $password;
			$entry["sambaPwdLastSet"][0] = time();

			if (ldap_mod_replace($this->ldap_connection, $dn, $entry)) {
				$this->change_password_samba4($username, $password);
				return true;
			} else {
				$this->error = ldap_errno($this->ldap_connection) . ": ".ldap_err2str(ldap_errno($this->ldap_connection));
				return false;
			}
		} else {
			//error je ze connect nastavil
			return false;
		}
	}

	private function change_password_samba4($username, $password) {
		$username = escapeshellarg($username);
		$password = escapeshellarg($password);
		// $out = shell_exec("sudo -u tinem ssh samba4.famnit.upr.si sudo \"/usr/local/samba/bin/samba-tool user setpassword $username --newpassword='$password'\"");
		$out = shell_exec("sudo -u samba_pw_sync ssh samba4.famnit.upr.si sudo \"/usr/local/samba/bin/samba-tool user setpassword $username --newpassword='$password'\"");
		file_put_contents("/tmp/samba4_log", date("Y-m-d H:i:s") . $username . " " . $password . "\n\n" . $out . "\n\n", FILE_APPEND);
	}

}